﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IWaitToKillServiceTimeoutStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class WaitToKillServiceTimeoutDefaultStrategy : ICorrespondenceOS, IWaitToKillServiceTimeoutStrategy
    {
        public WaitToKillServiceTimeoutDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "WaitToKillServiceTimeout";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control", RegName,
                              registryKey.GetValue(RegName, 20000), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class WaitToKillServiceTimeoutController
    {
        public WaitToKillServiceTimeoutController(WaitToKillServiceTimeout waitToKillServiceTimeout,
                                                         IWaitToKillServiceTimeoutStrategy strategy)
        {
            WaitToKillServiceTimeout = waitToKillServiceTimeout;
            Strategy = strategy;
        }

        public WaitToKillServiceTimeout WaitToKillServiceTimeout { get; set; }
        public IWaitToKillServiceTimeoutStrategy Strategy { get; set; }

        public void Read()
        {
            WaitToKillServiceTimeout.SetWaitToKillServiceTimeoutState(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(WaitToKillServiceTimeout.GetWaitToKillServiceTimeoutState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
